<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductPrice extends Model 
{

    protected $table = 'product_prices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product()
    {
        return $this->belongsTo('Product');
    }

    public function productSize()
    {
        return $this->belongsTo('ProductSize');
    }

    public function colorProduct()
    {
        return $this->belongsTo('ColorProduct');
    }

}